<?php

namespace RFTenant\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RfSubLease extends Model 
{

    protected $table = 'rf_sub_leases';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('rf_lease_id', 'tenant_type', 'name_ar', 'name_en', 'registration_no', 'tax_identifier_no', 'note');

    public function lease()
    {
        return $this->belongsTo('RFTenant\Models\RfLease');
    }

}